<?php

namespace App\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Costumer extends Model 
{

    protected $table = 'costumers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('first_name', 'last_name', 'phone', 'address', 'city_id');
    protected $visible = array('first_name', 'last_name', 'phone', 'address', 'city_id');

    public function city()
    {
        return $this->belongsTo('App\Entities\City');
    }

    public function adresses()
    {
        return $this->hasMany('App\Entities\Adresses');
    }

    public function users()
    {
        return $this->morphMany('App\Entities\User');
    }

}